/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;

public class ParametersImpl
extends Application.Parameters {
    private List<String> rawArgs = new ArrayList<String>();
    private Map<String, String> namedParams = new HashMap<String, String>();
    private List<String> unnamedParams = new ArrayList<String>();
    private List<String> readonlyRawArgs = null;
    private Map<String, String> readonlyNamedParams = null;
    private List<String> readonlyUnnamedParams = null;
    private static Map<Application, Application.Parameters> params = new HashMap<Application, Application.Parameters>();

    public ParametersImpl() {
    }

    public ParametersImpl(List<String> args) {
        if (args != null) {
            this.init(args);
        }
    }

    public ParametersImpl(String[] args) {
        if (args != null) {
            this.init(Arrays.asList(args));
        }
    }

    public ParametersImpl(Map params, String[] arguments) {
        this.init(params, arguments);
    }

    private void init(List<String> args) {
        for (String arg : args) {
            if (arg == null) continue;
            this.rawArgs.add(arg);
        }
        this.computeNamedParams();
        this.computeUnnamedParams();
    }

    private void init(Map params, String[] arguments) {
        for (Map.Entry e : params.entrySet()) {
            Object value;
            Object key = e.getKey();
            if (!this.validKey(key) || !((value = params.get(key)) instanceof String)) continue;
            this.namedParams.put((String)key, (String)value);
        }
        this.computeRawArgs();
        if (arguments != null) {
            for (String arg : arguments) {
                this.unnamedParams.add(arg);
                this.rawArgs.add(arg);
            }
        }
    }

    private boolean validFirstChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private boolean validKey(Object key) {
        String keyStr;
        if (key instanceof String && (keyStr = (String)key).length() > 0 && keyStr.indexOf(61) < 0) {
            return this.validFirstChar(keyStr.charAt(0));
        }
        return false;
    }

    private boolean isNamedParam(String arg) {
        if (arg.startsWith("--")) {
            return arg.indexOf(61) > 2 && this.validFirstChar(arg.charAt(2));
        }
        return false;
    }

    private void computeUnnamedParams() {
        for (String arg : this.rawArgs) {
            if (this.isNamedParam(arg)) continue;
            this.unnamedParams.add(arg);
        }
    }

    private void computeNamedParams() {
        for (String arg : this.rawArgs) {
            if (!this.isNamedParam(arg)) continue;
            int eqIdx = arg.indexOf(61);
            String key = arg.substring(2, eqIdx);
            String value = arg.substring(eqIdx + 1);
            this.namedParams.put(key, value);
        }
    }

    private void computeRawArgs() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.namedParams.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            this.rawArgs.add("--" + key + "=" + this.namedParams.get(key));
        }
    }

    @Override
    public List<String> getRaw() {
        if (this.readonlyRawArgs == null) {
            this.readonlyRawArgs = Collections.unmodifiableList(this.rawArgs);
        }
        return this.readonlyRawArgs;
    }

    @Override
    public Map<String, String> getNamed() {
        if (this.readonlyNamedParams == null) {
            this.readonlyNamedParams = Collections.unmodifiableMap(this.namedParams);
        }
        return this.readonlyNamedParams;
    }

    @Override
    public List<String> getUnnamed() {
        if (this.readonlyUnnamedParams == null) {
            this.readonlyUnnamedParams = Collections.unmodifiableList(this.unnamedParams);
        }
        return this.readonlyUnnamedParams;
    }

    public static Application.Parameters getParameters(Application app) {
        Application.Parameters p = params.get(app);
        return p;
    }

    public static void registerParameters(Application app, Application.Parameters p) {
        params.put(app, p);
    }
}

